/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	MirrorInY.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CEdit.h"
#include "CApplication.h"

HRESULT MirrorInY(ISet *objectSet1, ISet **newObjectSet1)
{

//	Creates a mirror of the object set along Y axis
//	and returns the newly created object set

	START_METHOD("MirrorInY")

	HRESULT status = CONV_SUCCESS;
	
	IApplication *pdApplication = NULL ;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication) ;
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *pGraphicDocument = NULL;
	status = pdApplication->GetActiveDoc(&pGraphicDocument);
	CHECK_RETURN_STATUS(status)

	IDirection *localY = NULL;
	status = activeWorkplane->GetLocalY(&localY);
	CHECK_RETURN_STATUS(status)

	ISet *objSet2 = NULL;
	status = activeGraphicDoc->MirrorLines(CAST(IObjectOrSet, objectSet1), activeSketch, localY, &objSet2);
	CHECK_RETURN_STATUS(status)

	*newObjectSet1 = objSet2;

	// Apply AutoConstrain on the set
	status = AddSet(objectSet1, objSet2);
	CHECK_RETURN_STATUS(status)

	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, objectSet1));
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, objSet2));
	CHECK_RETURN_STATUS(status)

	END_METHOD("MirrorInY")
}
